/*
 * @brief LPC11UXX global header file
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licenser disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include "board.h"

extern unsigned char RC5_flag;
extern unsigned char RC5_System;
extern unsigned char RC5_Command;

extern const char ascii[];

#ifdef __cplusplus
extern "C" {
#endif

extern void RC5_Init(void);
extern void USART0_Init(uint32_t baudrate);
extern char ua_getchar(void);
extern void ua_outchar(char c);
extern char ua_inchar(void);
extern void PrintWord(unsigned short w);
extern void PrintByte(unsigned char b);
extern void PrintString(const char *s);

#ifdef __cplusplus
}
#endif

#endif /* _GLOBAL_H_ */

